/* 
 *  UpdateCustomerAddressRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.PostalAddressListEntryI;

public class UpdateCustomerAddressRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(UpdateCustomerAddressRequest.class);
    private final PostalAddressListEntryI address;

    public UpdateCustomerAddressRequest(String interactionID, PostalAddressListEntryI address) {
        super(LOG, interactionID);
        this.address = address;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().updateCustomerAddress(address);
        LOG.trace(methodName + "-");
        return null;
    }
}
